/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class Speedometer {
    public static Map<EntityPlayerMP, Entry> playerMap = new LinkedHashMap<EntityPlayerMP, Entry>(1000);
    public static Map<EntityLiving, Integer> recentTeleports = new LinkedHashMap<EntityLiving, Integer>(10);

    @SubscribeEvent
    public static void playerUpdateEvent(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        if (event.phase == TickEvent.Phase.END && player instanceof EntityPlayerMP) {
            Speedometer.updatePlayer((EntityPlayerMP)player);
        }
    }

    @SubscribeEvent
    public static void teleport(EnderTeleportEvent event) {
        EntityLivingBase livingBase = event.getEntityLiving();
        if (livingBase instanceof EntityPlayerMP) {
            Speedometer.remove((EntityPlayerMP)livingBase);
        } else if (livingBase instanceof EntityLiving) {
            recentTeleports.put((EntityLiving)livingBase, 3);
        }
    }

    @SubscribeEvent
    public static void dimChange(EntityTravelToDimensionEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof EntityPlayerMP) {
            Speedometer.remove((EntityPlayerMP)entity);
        } else if (entity instanceof EntityLiving) {
            recentTeleports.put((EntityLiving)entity, 3);
        }
    }

    @SubscribeEvent
    public static void playerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            Speedometer.remove((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public static void serverTick(TickEvent.ServerTickEvent event) {
        recentTeleports.entrySet().removeIf(Speedometer::checkRemoveTeleporting);
    }

    private static boolean checkRemoveTeleporting(Map.Entry<EntityLiving, Integer> entry) {
        int time = entry.getValue();
        if (--time >= 0) {
            return true;
        }
        entry.setValue(time);
        return false;
    }

    private static void remove(EntityPlayerMP player) {
        playerMap.remove(player);
    }

    public static double getSpeed(Entity entity) {
        if (entity instanceof EntityPlayerMP) {
            Entry entry = playerMap.get(entity);
            return entry == null ? 0.0 : entry.calculatedSpeed;
        }
        if (recentTeleports.containsKey(entity)) {
            return 0.0;
        }
        return new Vec3d(entity.field_70169_q, entity.field_70167_r, entity.field_70166_s).func_72438_d(entity.func_174791_d()) * 20.0;
    }

    public static double updatePlayer(EntityPlayerMP player) {
        Vec3d newVec = player.func_174791_d();
        Entry entry = playerMap.get(player);
        if (entry == null) {
            playerMap.put(player, new Entry(newVec));
            return 0.0;
        }
        entry.set(newVec, entry.position.func_72438_d(newVec) * 20.0);
        return entry.calculatedSpeed;
    }

    public static class Entry {
        public Vec3d position;
        public double calculatedSpeed = 0.0;
        private double[] speeds = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};

        public Entry(Vec3d position) {
            this.position = position;
        }

        public void set(Vec3d position, double speed) {
            this.position = position;
            this.calculatedSpeed = 0.0;
            for (int i = this.speeds.length - 1; i > 0; --i) {
                this.speeds[i] = this.speeds[i - 1];
                this.calculatedSpeed += this.speeds[i];
            }
            this.speeds[0] = speed;
            this.calculatedSpeed = (this.calculatedSpeed + speed) / (double)this.speeds.length;
        }
    }
}

